
<?php
// ১. ডাটাবেস কানেকশন এবং সেশন শুরু
require_once 'db_connect.php';

// ইউজার লগইন আছে কিনা চেক করা
$is_logged_in = isset($_SESSION['user_id']);
$user_data = [];

if ($is_logged_in) {
    $user_id = $_SESSION['user_id'];
    $sql = "SELECT * FROM users WHERE id = '$user_id'";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>BOT CLUB - Trusted Betting Platform</title>
    <!-- ফন্ট অসাম আইকন -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- স্টাইল শিট (পরের ধাপে পাবেন) -->
    <link rel="stylesheet" href="style.css">
    <!-- গুগল ফন্ট -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
</head>
<body>

    <!-- =========================================
         SECTION 1: AUTHENTICATION (Login/Register)
         যদি ইউজার লগইন না থাকে, তাহলে এই সেকশন দেখাবে
    ========================================== -->
    <?php if (!$is_logged_in): ?>
    <div class="auth-container" id="auth-section">
        
        <!-- লোগো বা ব্যানার -->
        <div class="auth-header">
            <!-- DX WIN স্টাইল লোগো বসানোর জায়গা -->
            <img src="banner_1.webp" alt="Logo" class="auth-logo-img">
            <h2>Welcome Back</h2>
        </div>

        <div class="auth-box">
            <!-- ট্যাব বাটন -->
            <div class="auth-tabs">
                <button class="tab-btn active" onclick="showAuth('login')">Log In</button>
                <button class="tab-btn" onclick="showAuth('register')">Register</button>
            </div>

            <!-- লগইন ফর্ম -->
            <form id="login-form" class="auth-form active">
                <div class="input-group">
                    <i class="fas fa-mobile-alt"></i>
                    <input type="text" id="login_phone" placeholder="Phone Number" required>
                </div>
                <div class="input-group">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="login_password" placeholder="Password" required>
                </div>
                <button type="submit" class="submit-btn">Log In</button>
            </form>

            <!-- রেজিস্টার ফর্ম -->
            <form id="register-form" class="auth-form" style="display:none;">
                <div class="input-group">
                    <i class="fas fa-user"></i>
                    <input type="text" id="reg_username" placeholder="Username" required>
                </div>
                <div class="input-group">
                    <i class="fas fa-mobile-alt"></i>
                    <input type="text" id="reg_phone" placeholder="Phone Number" required>
                </div>
                <div class="input-group">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="reg_password" placeholder="Set Password" required>
                </div>
                <div class="input-group">
                    <i class="fas fa-code"></i>
                    <input type="text" id="reg_referral" placeholder="Invite Code (Optional)">
                </div>
                <div class="privacy-check">
                    <input type="checkbox" id="privacy" checked>
                    <label for="privacy">I agree to the Privacy Agreement</label>
                </div>
                <button type="submit" class="submit-btn">Register</button>
            </form>
        </div>
    </div>

    <?php else: ?>
    <!-- =========================================
         SECTION 2: MAIN APP (Logged In)
         যদি ইউজার লগইন থাকে, তাহলে এই সেকশন দেখাবে
    ========================================== -->
    <div class="app-container" id="app-section">
        
        <!-- উপরের হেডার (ব্যালেন্স) -->
        <header class="top-header">
            <div class="user-info">
                <img src="favicon.png" alt="Avatar" class="user-avatar">
                <div>
                    <span class="username"><?php echo htmlspecialchars($user_data['username']); ?></span>
                    <span class="uid">UID: <?php echo htmlspecialchars($user_data['u_id']); ?></span>
                </div>
            </div>
            <div class="balance-display">
                <span>৳ <?php echo number_format($user_data['balance'], 2); ?></span>
                <i class="fas fa-sync-alt" onclick="refreshBalance()"></i>
            </div>
            <div class="header-icons">
                <i class="fas fa-download"></i>
                <i class="fas fa-headset"></i>
            </div>
        </header>

        <!-- নোটিশ বার (Marquee) -->
        <div class="notice-bar">
            <i class="fas fa-volume-up"></i>
            <marquee behavior="scroll" direction="left">
                Welcome to BOT CLUB! Withdraw fast, safe and stable. Join our Telegram for signals.
            </marquee>
        </div>

        <!-- মেইন পেজ কন্টেন্ট -->
        <div class="content-area">
            
            <!-- HOME PAGE -->
            <div id="page-home" class="page active">
                <!-- স্লাইডার -->
                <div class="banner-slider">
                    <img src="banner_1.webp" alt="Promo">
                </div>

                <!-- গেম মেনু (DX WIN স্টাইল) -->
                <div class="game-categories">
                    <button class="cat-btn active">Lottery</button>
                    <button class="cat-btn">Slots</button>
                    <button class="cat-btn">Sports</button>
                    <button class="cat-btn">Casino</button>
                </div>

                <!-- WinGo গেমস লিস্ট -->
                <div class="game-grid">
                    <!-- WinGo 30s -->
                    <div class="game-card" onclick="openGame('wingo30s')">
                        <img src="ball_10.webp" alt="WinGo 30s">
                        <div class="game-title">WinGo 30s</div>
                        <div class="play-btn">Go ></div>
                    </div>
                    <!-- WinGo 1 Min -->
                    <div class="game-card" onclick="openGame('wingo1m')">
                        <img src="ball_11.webp" alt="WinGo 1m">
                        <div class="game-title">WinGo 1 Min</div>
                        <div class="play-btn">Go ></div>
                    </div>
                    <!-- WinGo 3 Min -->
                    <div class="game-card" onclick="openGame('wingo3m')">
                        <img src="ball_12.webp" alt="WinGo 3m">
                        <div class="game-title">WinGo 3 Min</div>
                        <div class="play-btn">Go ></div>
                    </div>
                    <!-- WinGo 5 Min -->
                    <div class="game-card" onclick="openGame('wingo5m')">
                        <img src="ball_13.webp" alt="WinGo 5m">
                        <div class="game-title">WinGo 5 Min</div>
                        <div class="play-btn">Go ></div>
                    </div>
                </div>
            </div>

            <!-- ACTIVITY PAGE (placeholder) -->
            <div id="page-activity" class="page" style="display:none;">
                <h2>Activity & Bonus</h2>
                <!-- এখানে বোনাস লিস্ট বসবে -->
            </div>

            <!-- WALLET PAGE (placeholder) -->
            <div id="page-wallet" class="page" style="display:none;">
                <div class="wallet-card">
                    <h3>Total Balance</h3>
                    <h1>৳ <?php echo number_format($user_data['balance'], 2); ?></h1>
                    <div class="wallet-btns">
                        <button class="w-btn deposit">Deposit</button>
                        <button class="w-btn withdraw">Withdraw</button>
                    </div>
                </div>
            </div>

            <!-- ACCOUNT PAGE -->
            <div id="page-account" class="page" style="display:none;">
                <div class="profile-header">
                    <h2>Member Center</h2>
                    <p>ID: <?php echo $user_data['u_id']; ?></p>
                </div>
                <ul class="profile-menu">
                    <li><i class="fas fa-wallet"></i> Wallet</li>
                    <li><i class="fas fa-users"></i> Promotion / Referral</li>
                    <li><i class="fas fa-gift"></i> Gift Code</li>
                    <li><i class="fas fa-cog"></i> Settings</li>
                    <li onclick="location.href='logout.php'" style="color:red;"><i class="fas fa-sign-out-alt"></i> Logout</li>
                </ul>
            </div>

            <!-- GAME INTERFACE (WinGo খেলার জায়গা) -->
            <div id="game-interface" class="page" style="display:none;">
                <div class="game-nav">
                    <button onclick="closeGame()"><i class="fas fa-chevron-left"></i> Back</button>
                    <span id="current-game-title">WinGo 30s</span>
                </div>
                
                <!-- টাইমার সেকশন -->
                <div class="timer-box">
                    <div class="period-info">
                        <p>Period</p>
                        <h3 id="period-number">Loading...</h3>
                    </div>
                    <div class="countdown-info">
                        <p>Time Remaining</p>
                        <h2 id="countdown-timer">00:00</h2>
                    </div>
                </div>

                <!-- বেটিং বাটন (Green/Violet/Red) -->
                <div class="bet-colors">
                    <button class="btn-green" onclick="showBetModal('Green')">Green</button>
                    <button class="btn-violet" onclick="showBetModal('Violet')">Violet</button>
                    <button class="btn-red" onclick="showBetModal('Red')">Red</button>
                </div>

                <!-- নাম্বার বেটিং -->
                <div class="bet-numbers">
                    <button onclick="showBetModal('0')" class="num-0">0</button>
                    <button onclick="showBetModal('1')" class="num-1">1</button>
                    <button onclick="showBetModal('2')" class="num-2">2</button>
                    <button onclick="showBetModal('3')" class="num-3">3</button>
                    <button onclick="showBetModal('4')" class="num-4">4</button>
                    <button onclick="showBetModal('5')" class="num-5">5</button>
                    <button onclick="showBetModal('6')" class="num-6">6</button>
                    <button onclick="showBetModal('7')" class="num-7">7</button>
                    <button onclick="showBetModal('8')" class="num-8">8</button>
                    <button onclick="showBetModal('9')" class="num-9">9</button>
                </div>

                <!-- Big/Small বেটিং -->
                <div class="bet-sizes">
                    <button class="btn-big" onclick="showBetModal('Big')">Big</button>
                    <button class="btn-small" onclick="showBetModal('Small')">Small</button>
                </div>

                <!-- গেম হিস্ট্রি টেবিল -->
                <div class="history-table">
                    <h4>Game Record</h4>
                    <table>
                        <thead>
                            <tr>
                                <th>Period</th>
                                <th>Number</th>
                                <th>Big/Small</th>
                                <th>Color</th>
                            </tr>
                        </thead>
                        <tbody id="game-history-body">
                            <!-- AJAX দিয়ে ডাটা আসবে -->
                        </tbody>
                    </table>
                </div>
            </div>

        </div> <!-- End Content Area -->

        <!-- নিচের নেভিগেশন বার (Bottom Nav) -->
        <nav class="bottom-nav">
            <a href="#" class="nav-item active" onclick="switchPage('home')">
                <i class="fas fa-home"></i>
                <span>Home</span>
            </a>
            <a href="#" class="nav-item" onclick="switchPage('activity')">
                <i class="fas fa-gem"></i>
                <span>Activity</span>
            </a>
            <a href="#" class="nav-item promotion-btn" onclick="alert('Promo Link Copy Logic Here')">
                <div class="promo-icon"><i class="fas fa-plus"></i></div>
                <span>Promotion</span>
            </a>
            <a href="#" class="nav-item" onclick="switchPage('wallet')">
                <i class="fas fa-wallet"></i>
                <span>Wallet</span>
            </a>
            <a href="#" class="nav-item" onclick="switchPage('account')">
                <i class="fas fa-user"></i>
                <span>Account</span>
            </a>
        </nav>

    </div>
    <?php endif; ?>

    <!-- Bet Confirmation Modal (Popup) -->
    <div id="bet-modal" class="modal" style="display:none;">
        <div class="modal-content">
            <h3>Select <span id="selected-bet-type"></span></h3>
            <div class="amount-input">
                <label>Balance: ৳ <span id="modal-balance"></span></label>
                <div class="input-wrapper">
                    <input type="number" id="bet-amount" value="10">
                </div>
                <div class="quick-amounts">
                    <button onclick="setAmount(10)">10</button>
                    <button onclick="setAmount(50)">50</button>
                    <button onclick="setAmount(100)">100</button>
                    <button onclick="setAmount(500)">500</button>
                </div>
            </div>
            <div class="modal-actions">
                <button onclick="document.getElementById('bet-modal').style.display='none'">Cancel</button>
                <button onclick="confirmBet()" class="confirm-btn">Bet</button>
            </div>
        </div>
    </div>

    <!-- JavaScript Logic -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Tab Switching for Login/Register
        function showAuth(type) {
            $('.tab-btn').removeClass('active');
            $('.auth-form').hide();
            if (type === 'login') {
                $('#login-form').show();
                $('.tab-btn:first-child').addClass('active');
            } else {
                $('#register-form').show();
                $('.tab-btn:last-child').addClass('active');
            }
        }

        // Page Switching (Home, Wallet, Account)
        function switchPage(pageName) {
            $('.page').hide();
            $('#page-' + pageName).show();
            $('.nav-item').removeClass('active');
            // Logic to highlight active nav item
            // This is a simplified version
        }

        // Open Game Interface
        function openGame(gameType) {
            $('.page').hide();
            $('#game-interface').show();
            $('#current-game-title').text(gameType.toUpperCase());
            $('.bottom-nav').hide(); // Hide bottom nav inside game
            // Here you would start the specific game timer logic via AJAX
        }

        function closeGame() {
            $('#game-interface').hide();
            $('#page-home').show();
            $('.bottom-nav').show();
        }

        // Bet Modal Logic
        function showBetModal(type) {
            $('#selected-bet-type').text(type);
            $('#bet-modal').show();
            // Need to set color class dynamically based on type
        }

        function setAmount(amount) {
            $('#bet-amount').val(amount);
        }

        // AJAX Login Handling (Simple Example)
        $('#login-form').on('submit', function(e) {
            e.preventDefault();
            // এখানে AJAX দিয়ে api.php তে রিকোয়েস্ট পাঠাতে হবে
            alert("Login functionality needs api.php!");
        });

        $('#register-form').on('submit', function(e) {
            e.preventDefault();
            alert("Register functionality needs api.php!");
        });

        function confirmBet() {
            alert("Bet Placed! (Backend Logic needed)");
            $('#bet-modal').hide();
        }
    </script>
</body>
</html>
